// Navbar Dropdown Fix - Bootstrap Compatible with Hover
console.log('🔧 Navbar Fix Loaded');

document.addEventListener('DOMContentLoaded', function() {
    // Initialize Bootstrap dropdowns properly
    const dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'));
    const dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
        return new bootstrap.Dropdown(dropdownToggleEl, {
            autoClose: 'outside'
        });
    });
    
    // Enhanced hover behavior for navbar dropdowns
    const navbarDropdowns = document.querySelectorAll('.navbar .dropdown');
    
    navbarDropdowns.forEach(dropdown => {
        const toggle = dropdown.querySelector('.dropdown-toggle');
        const menu = dropdown.querySelector('.dropdown-menu');
        let hoverTimeout;
        
        if (toggle && menu) {
            // Show dropdown on hover
            dropdown.addEventListener('mouseenter', function() {
                clearTimeout(hoverTimeout);
                
                // Use Bootstrap's dropdown instance to show
                const dropdownInstance = bootstrap.Dropdown.getInstance(toggle);
                if (dropdownInstance) {
                    dropdownInstance.show();
                } else {
                    // Fallback: create new instance and show
                    const newDropdown = new bootstrap.Dropdown(toggle);
                    newDropdown.show();
                }
            });
            
            // Hide dropdown when mouse leaves
            dropdown.addEventListener('mouseleave', function() {
                hoverTimeout = setTimeout(() => {
                    const dropdownInstance = bootstrap.Dropdown.getInstance(toggle);
                    if (dropdownInstance) {
                        dropdownInstance.hide();
                    }
                }, 150); // Small delay to prevent flickering
            });
            
            // Ensure dropdown items are clickable
            const dropdownItems = menu.querySelectorAll('.dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    // Allow normal link behavior
                    if (this.getAttribute('href') && this.getAttribute('href') !== '#') {
                        window.location.href = this.getAttribute('href');
                    }
                });
            });
        }
    });
    
    console.log('✅ Navbar dropdowns initialized with hover and click functionality');
});